/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

/* ///////////////////////////////////////////////////////////////////////// */
/*   File:  : metypes.h                                                      */
/*   Author : Chun-Jen Tsai                                                  */
/*   Date   : Dec/24/2002                                                    */
/* ------------------------------------------------------------------------- */
/*   Basic data type definitions.                                            */
/*   Copyright, 2002.                                                        */
/*   Multimedia Embedded Systems Lab.                                        */
/*   Department of Computer Science and Information engineering              */
/*   National Chiao Tung University, Hsinchu 300, Taiwan                     */
/* ///////////////////////////////////////////////////////////////////////// */

#ifndef __METYPES_H__
#define __METYPES_H__

/* The following two definitions are for fast, */
/*    word-size independent operations         */
typedef long xint;   // for DSP, int is of 16-bit, 2008/2/11 TF Shen
#ifndef _SYS_TYPES_H
typedef unsigned int uint;
#endif

typedef char mbchar;            /* this is for multibyte,      */
                                 /* unicode-like character def. */

#ifdef WIN32                    /* 32-bit Windows Platform */

typedef char int8;
typedef short int16;
typedef long int32;
typedef __int64 int64;

typedef unsigned __int64 uint64;
typedef unsigned long uint32;
typedef unsigned short uint16;
typedef unsigned char uint8;

#else /* 32-bit Linux */

typedef char int8;
typedef short int16;
typedef long int32;

typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long uint32;

#endif

#endif /* __METYPES_H__ */

/*
TI C5510 DSP Data types bit-width:

char        16 bits
short       16 bits
int         16 bits
long        32 bits
long long   40 bits
float       32 bits
double      64 bits
*/
